<?php
/*
 * 系统配文件
 * 所有系统级别的配置
 */

return array(
    
	/*---------------------------------------------
	 * @数据库备份还原控制器
	 * @第一：本控制器依靠config中的配置运行，须在config中新增配置：
	 *		'DB_PATH_NAME'=> 'db',        //备份目录名称,主要是为了创建备份目录；
	 *		'DB_PATH'     => './db/',     //数据库备份路径必须以 / 结尾；
	 *		'DB_PART'     => '20971520',  //该值用于限制压缩后的分卷最大长度。单位：B；建议设置20M
	 *		'DB_COMPRESS' => '1',         //压缩备份文件需要PHP环境支持gzopen,gzwrite函数        0:不压缩 1:启用压缩
	 *		'DB_LEVEL'    => '9',         //压缩级别   1:普通   4:一般   9:最高
	 * @第二：本控制器依赖ThinkPHP/Library/OT/Database.class.php
	 * @第三：在Application/Common/function.php里面加个format_bytes()函数；
				/**
				 * 格式化字节大小
				 * @param  number $size      字节数
				 * @param  string $delimiter 数字和单位分隔符
				 * @return string            格式化后的带单位的大小
				 *
				function format_bytes($size, $delimiter = '') {
					$units = array('B', 'KB', 'MB', 'GB', 'TB', 'PB');
					for ($i = 0; $size >= 1024 && $i < 5; $i++) $size /= 1024;
					return round($size, 2) . $delimiter . $units[$i];
				}
	 * @第四：模版文件，Home/View/Database下面的2个文件 export.html备份数据库  import.html还原数据库
	 * @第五：模版文件中需jquery支持（模版中有ajax），并且要想实现模版中的多选需引用以下js：
	 		 <script>
	 			;$(function(){
					//全选的实现
					$(".check-all").click(function(){
						$(".ids").prop("checked", this.checked);
					});
					$(".ids").click(function(){
						var option = $(".ids");
						option.each(function(i){
							if(!this.checked){
								$(".check-all").prop("checked", false);
								return false;
							}else{
								$(".check-all").prop("checked", true);
							}
						});
					});
				
				});
	         </script>
	 * @第六：引用方法：<a href="{:U('Database/index',array('type'=>'export'))}">备份数据库</a>
	 * 		          <a href="{:U('Database/index',array('type'=>'import'))}">还原数据库</a>
	 * Author: 枫LT <957987132@qq.com>
	 *---------------------------------------------
	 */
	'DB_PATH_NAME'=> 'db',        //备份目录名称,主要是为了创建备份目录
	'DB_PATH'     => './db/',     //数据库备份路径必须以 / 结尾；
	'DB_PART'     => '20971520',  //该值用于限制压缩后的分卷最大长度。单位：B；建议设置20M
	'DB_COMPRESS' => '1',         //压缩备份文件需要PHP环境支持gzopen,gzwrite函数        0:不压缩 1:启用压缩
	'DB_LEVEL'    => '9',         //压缩级别   1:普通   4:一般   9:最高

);
